<?php

if (session_status() === PHP_SESSION_NONE) session_start();
if (!isset($_SESSION['reid'])) header('location:index.php');

require_once("../dashboard/conn.php");

require_once '../dashboard/dbconfig4.php';

if(isset($_SESSION['reid'])){

	$user_qury=mysqli_query($conn,"SELECT * FROM ormsregister WHERE reid='$_SESSION[reid]'");

	$user_resalt=mysqli_fetch_array($user_qury);

	$customer = $user_resalt['reid'];
	
	$addbycustomer = $user_resalt['userid'];
	
	$userbalance = number_format((float)$user_resalt['balance'],2);
	
	$sellertype = $user_resalt['sellertype'];
	
	if($user_resalt['image']==""){

		$image_path="../dashboard/images/empty.jpg";

	}

	else{

		$image_path="../dashboard/images/sellers/".$user_resalt['image'];

	}

}


$msg5 = '';	

if(isset($_POST['add_customers']))

	{

        $title = $_POST['title'];
		$fname = $_POST['fname'];
		$lname = $_POST['lname'];
		$shopname = $_POST['shopname'];
		$sellertype = $_POST['sellertype'];
		$sellerpackage = $_POST['sellerpackage'];
		$username = $_POST['username'];
		$email = $_POST['email'];
		$mobilenumber=(int)mysqli_real_escape_string($conn,$_POST['mobilenumber	']);
		$to="0".(int)mysqli_real_escape_string($conn,$_POST['mobilenumber	']);
		$nicnumber = $_POST['nicnumber'];
		$shopaddress = $_POST['shopaddress'];
		$country = $_POST['country'];
		$province = $_POST['province'];
		$district = $_POST['district'];
		$division = $_POST['division'];
		$creditadd = $_POST['creditadd'];	
		$password=md5(mysqli_real_escape_string($con,$_POST['password']));
		$confirm_password=md5(mysqli_real_escape_string($con,$_POST['confirm_password']));
		$status = $_POST['status'];	
		
		if(empty($title)){			
		$errMSG = "Please Select Title.";
		}else if(empty($fname)){			
		$errMSG = "Please Enter First Name.";
		}else if(empty($lname)){			
		$errMSG = "Please Enter Last Name.";
		}else if(empty($shopname)){
		$errMSG = "Please Enter Shop Name.";
		}else if(empty($sellertype)){			
		$errMSG = "Please Select Seller Type.";
		}else if(empty($sellerpackage)){
		$errMSG = "Please Select Seller Package.";
		}else if(empty($username)){			
		$errMSG = "Please Enter Username.";
		}else if(empty($email)){
		$errMSG = "Please Enter Email Address.";
		}else if(empty($mobilenumber)){			
		$errMSG = "Please Enter Mobile Number.";
		}else if(empty($nicnumber)){
		$errMSG = "Please Enter Nic Number.";
		}else if(empty($shopaddress)){
		$errMSG = "Please Enter Shop Address.";
		}else if(empty($country)){
		$errMSG = "Please Select Country.";
		}else if(empty($province)){
		$errMSG = "Please Select Province.";
		}else if(empty($district)){
		$errMSG = "Please Select District.";
		}else if(empty($division)){
		$errMSG = "Please Select $division.";
		}else if(empty($creditadd)){
		$errMSG = "Please Enter Credit Add.";
		}else if(empty($status)){
		$errMSG = "Please Select Status.";
		}

		// if no error occured, continue ....
		if(!isset($errMSG))
		{
			$stmt = $DB_con->prepare('INSERT INTO ormsregister(fname,lname,shopname,sellertype,sellerpackage,username,email,mobilenumber,nicnumber,shopaddress,country,province,district,division,creditadd,password,status) VALUES(:fname,:lname,:shopname,:sellertype,:sellerpackage,:username,:email,:mobilenumber,:nicnumber,:shopaddress,:country,:province,:district,:division,:creditadd,:password,:status)');
			$stmt->bindParam(':title',$title);						
			$stmt->bindParam(':fname',$fname);						
			$stmt->bindParam(':lname',$lname);
			$stmt->bindParam(':shopname',$shopname);
			$stmt->bindParam(':sellertype',$sellertype);
			$stmt->bindParam(':sellerpackage',$sellerpackage);
			$stmt->bindParam(':username',$username);						
			$stmt->bindParam(':email',$email);						
			$stmt->bindParam(':mobilenumber',$mobilenumber);
			$stmt->bindParam(':nicnumber',$nicnumber);
			$stmt->bindParam(':shopaddress',$shopaddress);
			$stmt->bindParam(':country',$country);
			$stmt->bindParam(':province',$province);						
			$stmt->bindParam(':district',$district);						
			$stmt->bindParam(':division',$division);
			$stmt->bindParam(':creditadd',$creditadd);
			$stmt->bindParam(':password',$password);
			$stmt->bindParam(':status',$status);

			if($stmt->execute())

			{

				$successMSG = "Sellers/Customers Successfully Added.";

				header("refresh:2;customers.php"); // redirects image view page after 5 seconds.

			}

			else

			{

				$errMSG = "error while inserting....";

			}
		
}
		
}

?>

<!DOCTYPE html>
<html lang="en">

<head>
	<meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <title>API Documentation | Recharge and Billing System | ORMS | Dashbaord</title>
	
	<?php
	require_once 'headercss.php';
	?>

</head>

<body>

    <!--**********************************
        Main wrapper start
    ***********************************-->
    <div id="main-wrapper">

        <?php

		require_once 'header.php';

		?>

        <!--**********************************
            Sidebar start
        ***********************************-->
        <div class="deznav">
            <div class="deznav-scroll">
<?php

require_once 'sidebarmenu.php';

?>
            </div>
        </div>
        <!--**********************************
            Sidebar end
        ***********************************-->
		
        <!--**********************************
            Content body start
        ***********************************-->
        <div class="content-body">
            <!-- row -->
            <div class="container-fluid">
				<div class="row">
				<div class="col-xl-12 col-xxl-12 col-sm-12">
				<div class="alert alert-danger bg-danger text-white" role="alert">
				<strong>Alert!</strong> ඔබගේ ගිනුම තහවුරු කිරීම අසම්පුර්නයි.<a href="identity_verify.php" class="btn btn-success float-right" style="background-color:#0847cb;font-weight:bold;font-size:18px;color:#ffffff;padding:4px 4px;">සම්පුර්න කරන්න</a>
				</div>
				</div>
				</div>    
                <div class="row page-titles mx-0">
                    <div class="col-sm-6 p-md-0">
                        <div class="welcome-text">
                            <h4>API Documentation</h4>
                        </div>
                    </div>
                    <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="index.php">Home</a></li>
                            <li class="breadcrumb-item"><a href="javascript:void(0);">API Documentation</a></li>
                            <li class="breadcrumb-item active"><a href="javascript:void(0);">API Documentation</a></li>
                        </ol>
                    </div>
                </div>
				
				<div class="row">
					<div class="col-lg-12">
					<div class="container" style="max-width: 50rem">
			<div class="card">
				<div class="card-body">
					<h1 class="text-center mb-3">RELOAD REQUEST [POST]</h1>
					<h4 class="text-info pl-4">HTTP Method: POST</h4>
					<h4 class="text-info pl-4">API URL: https://manager.quickpaylanka.com/post/send-recharge/</h4>
					<hr>
					<pre class="prettyprint prettyprinted" style=""><span class="pln">						</span><code class="language-markup" id="sample_code_php"><span class="pln">
							</span><p><span class="pun">&lt;?</span><span class="pln">php</span><br><span class="pln">$user_name </span><span class="pun">=</span><span class="pln"> </span><span class="str">"user"</span><span class="pun">;</span><br><span class="pln">$api_key </span><span class="pun">=</span><span class="pln"> </span><span class="str">"xxxxxxxxxxx"</span><span class="pun">;</span><br><span class="pln">$number </span><span class="pun">=</span><span class="pln"> </span><span class="str">"071XXXXXXXX"</span><span class="pun">;</span><br><span class="pln">$provider_code </span><span class="pun">=</span><span class="pln"> </span><span class="str">"MOBP"</span><span class="pun">;</span><br><span class="pln">$amount </span><span class="pun">=</span><span class="pln"> </span><span class="str">"50"</span><span class="pun">;</span><br><span class="pln">$merchant_ref </span><span class="pun">=</span><span class="pln"> </span><span class="str">"TEST01"</span><span class="pun">;</span><br><span class="pln">$ref_mobile_number </span><span class="pun">=</span><span class="pln"> </span><span class="str">"071YYYYYYY"</span><span class="pun">;</span></p><span class="pln">
							</span><p><span class="pln">$data </span><span class="pun">=</span><span class="pln"> array</span><span class="pun">(</span><br><span class="str">"user_name"</span><span class="pln"> </span><span class="pun">=&gt;</span><span class="pln"> $user_name</span><span class="pun">,</span><br><span class="str">"api_key"</span><span class="pln"> </span><span class="pun">=&gt;</span><span class="pln"> $api_key</span><span class="pun">,</span><br><span class="str">"number"</span><span class="pln"> </span><span class="pun">=&gt;</span><span class="pln"> $number</span><span class="pun">,</span><br><span class="str">"provider_code"</span><span class="pln"> </span><span class="pun">=&gt;</span><span class="pln"> $provider_code</span><span class="pun">,</span><br><span class="str">"amount"</span><span class="pln"> </span><span class="pun">=&gt;</span><span class="pln"> $amount</span><span class="pun">,</span><br><span class="str">"merchant_ref"</span><span class="pln"> </span><span class="pun">=&gt;</span><span class="pln"> $merchant_ref</span><span class="pun">,</span><br><span class="str">"ref_mobile_number"</span><span class="pln"> </span><span class="pun">=&gt;</span><span class="pln"> $ref_mobile_number</span><br><span class="pun">);</span><br><br><span class="pln">$data_string </span><span class="pun">=</span><span class="pln"> json_encode</span><span class="pun">(</span><span class="pln">$data</span><span class="pun">);</span></p><span class="pln">
							</span><p><span class="pln">$ch </span><span class="pun">=</span><span class="pln"> curl_init</span><span class="pun">(</span><span class="str">'https://manager.quickpaylanka.com/post/send-recharge/'</span><span class="pun">);</span><br><span class="pln">curl_setopt</span><span class="pun">(</span><span class="pln">$ch</span><span class="pun">,</span><span class="pln"> CURLOPT_CUSTOMREQUEST</span><span class="pun">,</span><span class="pln"> </span><span class="str">"POST"</span><span class="pun">);</span><br><span class="pln">curl_setopt</span><span class="pun">(</span><span class="pln">$ch</span><span class="pun">,</span><span class="pln"> CURLOPT_POSTFIELDS</span><span class="pun">,</span><span class="pln"> $data_string</span><span class="pun">);</span><br><span class="pln">curl_setopt</span><span class="pun">(</span><span class="pln">$ch</span><span class="pun">,</span><span class="pln"> CURLOPT_RETURNTRANSFER</span><span class="pun">,</span><span class="pln"> </span><span class="kwd">true</span><span class="pun">);</span><br><span class="pln">curl_setopt</span><span class="pun">(</span><span class="pln">$ch</span><span class="pun">,</span><span class="pln"> CURLOPT_HTTPHEADER</span><span class="pun">,</span><span class="pln"> array</span><span class="pun">(</span><br><span class="str">'Content-Type: application/json'</span><span class="pun">,</span><br><span class="str">'Content-Length: '</span><span class="pln"> </span><span class="pun">.</span><span class="pln"> strlen</span><span class="pun">(</span><span class="pln">$data_string</span><span class="pun">))</span><br><span class="pun">);</span><br><span class="pln">curl_setopt</span><span class="pun">(</span><span class="pln">$ch</span><span class="pun">,</span><span class="pln"> CURLOPT_TIMEOUT</span><span class="pun">,</span><span class="pln"> </span><span class="lit">30</span><span class="pun">);</span><br><span class="pln">curl_setopt</span><span class="pun">(</span><span class="pln">$ch</span><span class="pun">,</span><span class="pln"> CURLOPT_CONNECTTIMEOUT</span><span class="pun">,</span><span class="pln"> </span><span class="lit">30</span><span class="pun">);</span></p><span class="pln">
							</span><p><span class="com">//execute post</span><br><span class="pln">$result </span><span class="pun">=</span><span class="pln"> curl_exec</span><span class="pun">(</span><span class="pln">$ch</span><span class="pun">);</span></p><span class="pln">
							</span><p><span class="com">//close connection</span><br><span class="pln">curl_close</span><span class="pun">(</span><span class="pln">$ch</span><span class="pun">);</span></p><span class="pln">
							</span><p><span class="pln">echo $result</span><span class="pun">;</span><br><span class="pun">?&gt;</span></p><span class="pln">
						</span></code><span class="pln">
					</span></pre>
					<div class="p-3">
						<table class="table table-bordered">
							<thead class="thead-dark">
								<tr>
									<th>Parameter</th>
									<th>Data Type</th>
									<th>Value</th>
									<th>Description</th>
								</tr>
							</thead>
							<tbody>
								<tr>
									<td>user_name</td>
									<td>String</td>
									<td>Required</td>
									<td>Reload API Username</td>
								</tr>
								<tr>
									<td>api_key</td>
									<td>String</td>
									<td>Required</td>
									<td>Reload API Key</td>
								</tr>
								<tr>
									<td>number</td>
									<td>Integer</td>
									<td>Required</td>
									<td>Service Request Mobile / Account Number</td>
								</tr>
								<tr>
									<td>provider_code</td>
									<td>String</td>
									<td>Required</td>
									<td>
										<button type="button" class="btn btn-primary" data-toggle="modal" data-target="#providerCodes">VIEW PROVIDER CODES</button>
									</td>
								</tr>
								<tr>
									<td>amount</td>
									<td>Integer</td>
									<td>Required</td>
									<td>Reload / Bill Amount</td>
								</tr>
								<tr>
									<td>merchant_ref</td>
									<td>String</td>
									<td>Required</td>
									<td>Merchant Reference ID</td>
								</tr>
								<tr>
									<td>ref_mobile_number</td>
									<td>Integer</td>
									<td>Optional</td>
									<td>Mobile Number to Send Receipt</td>
								</tr>
							</tbody>
						</table>
					</div>
					<h4 class="text-info pl-4">Output Example</h4>
					<pre class="prettyprint prettyprinted" style=""><span class="pln">						</span><code class="language-markup" id="sample_code_php"><span class="pln">
							</span><p><span class="pun">{</span><br><span class="pln">       </span><span class="str">"status"</span><span class="pun">:</span><span class="pln"> </span><span class="str">"SENDING"</span><span class="pun">,</span><br><span class="pln">       </span><span class="str">"status_code"</span><span class="pun">:</span><span class="pln"> </span><span class="str">"100"</span><span class="pun">,</span><br><span class="pln">       </span><span class="str">"reference"</span><span class="pun">:</span><span class="pln"> </span><span class="str">"123456"</span><span class="pun">,</span><br><span class="pln">       </span><span class="str">"description"</span><span class="pun">:</span><span class="pln"> </span><span class="str">"SENT FOR PROCESSING"</span><span class="pun">,</span><br><span class="pln">       </span><span class="str">"balance"</span><span class="pun">:</span><span class="pln"> </span><span class="str">"10000.82"</span><br><span class="pun">}</span></p><span class="pln">
						</span></code><span class="pln">
					</span></pre>
				</div>
			</div>
		</div>
					</div>
				</div>
				
            </div>
        </div>
        <!--**********************************
            Content body end
        ***********************************-->

		<?php
		require_once 'footer.php';
		?>

		<!--**********************************
           Support ticket button start
        ***********************************-->

        <!--**********************************
           Support ticket button end
        ***********************************-->

    </div>
    <!--**********************************
        Main wrapper end
    ***********************************-->

    <?php
	require_once 'footerjs.php';
	?>
    
</body>
</html>